// OpenGL FrameworkDoc.cpp : Implementierung der Klasse COpenGLFrameworkDoc
//

#include "stdafx.h"
#include "OpenGL Framework.h"

#include "OpenGL FrameworkDoc.h"
#include <math.h>
#include "glTexFont.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define glRGB(x, y, z)	glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)
#define GL_PI 4 * atan(1)

// Display lists
#define LANDSCAPE_LIST 1
#define SKYBOX_LIST 2
#define WEAPON_LIST 3
#define SPHERE_LIST 4

// Conversion factor for converting between degrees and radians
#define PI_OVER_180 0.0174532925f

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkDoc

IMPLEMENT_DYNCREATE(COpenGLFrameworkDoc, CDocument)

BEGIN_MESSAGE_MAP(COpenGLFrameworkDoc, CDocument)
	//{{AFX_MSG_MAP(COpenGLFrameworkDoc)
		// HINWEIS - Hier werden Mapping-Makros vom Klassen-Assistenten eingefgt und entfernt.
		//    Innerhalb dieser generierten Quelltextabschnitte NIHTS VERNDERN!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkDoc Konstruktion/Destruktion

COpenGLFrameworkDoc::COpenGLFrameworkDoc()
{
	// ZU ERLEDIGEN: Hier Code fr One-Time-Konstruktion einfgen
}

COpenGLFrameworkDoc::~COpenGLFrameworkDoc()
{
}

BOOL COpenGLFrameworkDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// ZU ERLEDIGEN: Hier Code zur Reinitialisierung einfgen
	// (SDI-Dokumente verwenden dieses Dokument)

	// Load font file
	fontLoad								("gfx/Font.tga");
		
	// Load textures
	m_SkyBox.m_SkyTexture.LoadBMP			("gfx/Background.bmp");
	m_SkyBox.m_WaterTexture.LoadBMP			("gfx/Water.bmp");
	m_WeaponTexture.LoadBMP					("gfx/Weapon.bmp");
	m_SphereTexture.LoadBMP					("gfx/Sphere.bmp");
	m_EnvironmentTexture.LoadBMP			("gfx/Environment.bmp");
	m_Camera.m_Landscape.m_Texture.LoadBMP	("gfx/Landscape.bmp");

	// Generate display lists

	// Landscape
		
	// Point in Mandelbrot set & which value a point must overstep to be drawn

	// Landscape 1
	/*
	m_Camera.m_Landscape.m_CX = 0.251f;
	m_Camera.m_Landscape.m_CY = 0.00002f;
	m_Camera.m_Landscape.m_MinimumHeight = 0.14f;
	// Move camera to the start point
	m_Camera.m_XPos = 0.75f;
	m_Camera.m_YPos = 0.16f;
	m_Camera.m_ZPos = 0.1f;
	m_Camera.m_YRotate = 90.0f;
	*/

	// Landscape 2
	/*
	m_Camera.m_Landscape.m_CX = -0.92f;
	m_Camera.m_Landscape.m_CY = 0.28f;
	m_Camera.m_Landscape.m_MinimumHeight = 0.017f;
	// Move camera to the start point
	m_Camera.m_XPos = 0.37f;
	m_Camera.m_YPos = 0.008f;
	m_Camera.m_ZPos = -0.76f;
	m_Camera.m_YRotate = 135.0f;
	*/

	// Landscape 3
	
	m_Camera.m_Landscape.m_CX = -0.75f;
	m_Camera.m_Landscape.m_CY = 0.1f;
	m_Camera.m_Landscape.m_MinimumHeight = 0.0185f;
	// Move camera to the start point
	m_Camera.m_XPos = 0.37f;
	m_Camera.m_YPos = 0.055f;
	m_Camera.m_ZPos = -0.46f;
	m_Camera.m_YRotate = 200.0f;
	
	// Range
	m_Camera.m_Landscape.m_XMin = -2.0f;
	m_Camera.m_Landscape.m_XMax = 2.0f;
	m_Camera.m_Landscape.m_YMin = -2.0f;
	m_Camera.m_Landscape.m_YMax = 2.0f;
	// Distance between two calculated points (accurancy)
	m_Camera.m_Landscape.m_StepSize = 0.045f; 
	// How often the iteration for one point will be repeated
	m_Camera.m_Landscape.m_IterationDepth = 450;
	// Which value a point must overstep to be part of the Julia set
	m_Camera.m_Landscape.m_Limit = (unsigned long) 1E5;
	// Brightness adjustment
	m_Camera.m_Landscape.m_Brightness = 0.5f;
	// Generate display list
	m_Camera.m_Landscape.GenerateLandscape(LANDSCAPE_LIST);
	
	// Skybox
	m_SkyBox.m_SkyBoxSize = 3.0f;
	m_SkyBox.GenerateSkyBox(SKYBOX_LIST);

	// Weapon
	DrawWeapon(WEAPON_LIST);

	// Sphere
	DrawSphere(SPHERE_LIST);

	// Setup lighting, color tracking etc.
	SetupRC();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkDoc Serialisierung

void COpenGLFrameworkDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// ZU ERLEDIGEN: Hier Code zum Speichern einfgen
	}
	else
	{
		// ZU ERLEDIGEN: Hier Code zum Laden einfgen
	}
}

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkDoc Diagnose

#ifdef _DEBUG
void COpenGLFrameworkDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void COpenGLFrameworkDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkDoc Befehle

void COpenGLFrameworkDoc::RenderScene()
{
	// Clear depth buffer
	glClear(GL_DEPTH_BUFFER_BIT);

	// Draw world (landscape & sphere)
 
	// Save matrix
	glPushMatrix(); 
		// Camera transformation
		m_Camera.TransformWorld();
		// Define light position relative to the transformed landscape
		GLfloat LightPos[] = { 1.5f, 0.0f, -4.0f, 0.0f };
		glLightfv(GL_LIGHT0, GL_POSITION, LightPos);
		// Draw background
		m_SkyBox.DrawSkyBox();
		// Draw landscape
		m_Camera.m_Landscape.DrawLandscape();
		// Draw sphere
		glTranslatef(0.2f, 0.35f, 0.1f);
		glCallList(SPHERE_LIST);
	// Restore Matrix
	glPopMatrix();

	// Draw weapon

	// Save matrix
	glPushMatrix();
		// Calculate weapon offset
		float fXOffset = sinf(m_Camera.m_WalkBiasAngle / 2 * PI_OVER_180) / 700.0f + 0.015f;
		float fYOffset = m_Camera.m_WalkBias / 45 - 0.017f;
		float fZOffset = -0.07f;
		// Move to the right position
		glTranslatef(fXOffset, fYOffset, fZOffset);	
		// Call weapon list
		//glCallList(WEAPON_LIST);				
	glPopMatrix();

	// Draw font overlays

	// HUD / crosshair
	//DrawFont();

	// Debug

	#ifdef _DEBUG
		fontDrawString(5, m_ViewportHeight - 15, "X:%f", m_Camera.m_XPos);
		fontDrawString(5, m_ViewportHeight - 25, "Y:%f", m_Camera.m_YPos);
		fontDrawString(5, m_ViewportHeight - 35, "Z:%f", m_Camera.m_ZPos);
		fontDrawString(5, m_ViewportHeight - 45, "W:%f", m_Camera.m_YRotate);
		fontDrawString(5, m_ViewportHeight - 55, "T:%i", m_Camera.m_Landscape.m_TriangleCount);
	#endif

	// Flush rendering pipeline
	glFlush();
}

void COpenGLFrameworkDoc::SetupRC()
{
	// Setup the RC

	// Settings
	glEnable(GL_DEPTH_TEST);	// Z-Buffer
	glEnable(GL_CULL_FACE);		// Backface Culling
	glEnable(GL_TEXTURE_2D);	// Texturing
			
	// Fog
	glHint(GL_FOG, GL_NICEST);

	/*
	glEnable(GL_FOG);			
	glFogf(GL_FOG_DENSITY, 1.0f);
	glFogi(GL_FOG_MODE, GL_EXP2);
	glFogf(GL_FOG_START, 3.0f);
	GLfloat FogColor[] = { 0.0f, 0.0f, 0.0f, 0.5f };
	glFogfv(GL_FOG_COLOR, FogColor);
	*/
	
	// Solid front polygons
	glPolygonMode(GL_FRONT, GL_FILL);
		
	// Enable lighting
	glEnable(GL_LIGHTING);
 
	// Lighting settings
	GLfloat AmbientLight[]        = { 0.5f, 0.5f, 0.5f, 1.0f };
	GLfloat DiffuseLight[]        = { 0.5f, 0.5f, 0.5f, 1.0f };
	GLfloat OtherReflectance[]    = { 1.75f, 1.75f, 1.75f, 1.0f };
	GLfloat LightPos[]            = { 0.0f, 1.0f, 0.0f, 0.0f };
			
	// Define light 0
	glLightfv(GL_LIGHT0, GL_AMBIENT, AmbientLight);	  // Ambient
	glLightfv(GL_LIGHT0, GL_DIFFUSE, DiffuseLight);	  // Diffuse
	glLightfv(GL_LIGHT0, GL_POSITION, LightPos);	  // Position
	
	// Enable light 0
	glEnable(GL_LIGHT0);

	// Ambient reflectance settings
	glMaterialfv(GL_FRONT, GL_AMBIENT, OtherReflectance);
	
	// Enable color tracking
	glEnable(GL_COLOR_MATERIAL);
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);

	// Set clear color to black
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
}

void COpenGLFrameworkDoc::DrawFont()
{
	// Draw font overlays
	
	// Winding must be counter-clockwise
	glFrontFace(GL_CCW);

	// Draw crosshair
	fontSize(24);
	fontColor(1.0f, 1.0f, 1.0f);
	fontDrawString (m_ViewportWidth / 2 - 12, m_ViewportHeight / 2 - 12, "+");

	// Draw HUD stuff

	// HUD font size & location
	const int iFontSize = 40;
	const int iSpacing = 30;
	const int iVertSpacing = 12;

	// Health
	fontSize(iFontSize);
	fontColor(1.0f, 0.7f, 0.0f);
	fontDrawString (iSpacing, iVertSpacing, "\\b+100");
	fontDrawString (iSpacing + 21, iVertSpacing - 9, "HEALTH");

	// Armor
	fontSize(iFontSize);
	fontColor(1.0f, 0.7f, 0.0f);
	fontDrawString ((m_ViewportWidth / 2) - (int)
		(iFontSize * 1.5), iVertSpacing, "\\b+000");
	fontDrawString ((m_ViewportWidth / 2) - (int)
		(iFontSize * 1.5) + 31, iVertSpacing - 9, "ARMOR");

	// Ammo
	fontSize(iFontSize);
	fontColor(1.0f, 0.7f, 0.0f);
	fontDrawString (m_ViewportWidth - (iFontSize * 3) - iSpacing, iVertSpacing, "\\b+050");
	fontDrawString (m_ViewportWidth - (iFontSize * 3) - iSpacing + 35, iVertSpacing - 9, "AMMO");
}

void COpenGLFrameworkDoc::DrawWeapon(const int iListIndex)
{
	// Draw player weapon
	
	// Use passed display list index
	glNewList(iListIndex, GL_COMPILE);
		
		// Save depth buffering state
		glPushAttrib(GL_DEPTH_BUFFER_BIT);	

			// Disable depth buffering
			glDisable(GL_DEPTH_TEST);

			// Counter-clockwise windig
			glFrontFace(GL_CCW);

			// Base color is a light blue
			glColor3f(0.8f, 0.8f, 1.0f);
			
			// Use weapon texture
			m_WeaponTexture.Use();

			// Draw textured cylinder
			GLUquadricObj* pQuadric1;
			pQuadric1 = gluNewQuadric();
			gluQuadricTexture(pQuadric1, TRUE);
			gluCylinder(pQuadric1, 0.003, 0.004, 0.06, 25, 1);
			
			// Delete quadric object
			gluDeleteQuadric(pQuadric1);

		glPopAttrib();

	glEndList();
}

void COpenGLFrameworkDoc::DrawSphere(const int iListIndex)
{
	// Draw sphere
	
	// Use passed display list index
	glNewList(iListIndex, GL_COMPILE);
		
		// Save fog bit
		glPushAttrib(GL_FOG_BIT);
		
			// Make white fog
			glEnable(GL_FOG);			
			glFogf(GL_FOG_DENSITY, 1.3f);
			glFogi(GL_FOG_MODE, GL_EXP2);
			glFogf(GL_FOG_START, 0.5f);
			GLfloat FogColor[] = { 0.5f, 0.5f, 1.0f, 1.0f };
			glFogfv(GL_FOG_COLOR, FogColor);
			
			// Winding must be counter-clowise
			glFrontFace(GL_CCW);

			// Base color is white
			glColor3f(0.75f, 0.75f, 0.75f);
			
			// Create textured quadric
			GLUquadricObj* pQuadric1;
			pQuadric1 = gluNewQuadric();
			gluQuadricTexture(pQuadric1, TRUE);

			// Save state
			m_SphereTexture.SaveState();
				// Use sphere texture
				m_SphereTexture.Use();
				// Enable transparency
				m_SphereTexture.Transparency();
     			// No Z-buffer writes
				// (will be restored by texture class)
				glDepthMask(0);
				// Draw transparent textured sphere
				gluSphere(pQuadric1, 0.1, 15, 15);
			m_SphereTexture.RestoreState();

			// Save state
			m_EnvironmentTexture.SaveState();
				// Use environment texture
				m_EnvironmentTexture.Use();
				// Enable transparency
				m_EnvironmentTexture.Transparency();
				// Enable environment mapping
				m_EnvironmentTexture.EnvironmentMapping();
				// Draw environment mapped sphere
				gluSphere(pQuadric1, 0.1, 15, 15);
			m_EnvironmentTexture.RestoreState();

			// Delete quadric object
			gluDeleteQuadric(pQuadric1);

		glPopAttrib();

	glEndList();
}
